<?xml version="1.0" encoding="utf-8" ?> 

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>

	

	<xsl:include href="../../apt/views/spreadsheetview.xslt"/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>



	<xsl:template match='/property'>

		<xsl:call-template name="spreadsheet_start">

			<xsl:with-param name="nohandler">true</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="spreadsheet_columns_def">

		<xsl:param name="hidden"/>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Name</xsl:with-param>

			<xsl:with-param name="width">40%</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Value</xsl:with-param>

			<xsl:with-param name="width">60%</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>
		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="spreadsheet_rows_def">

		<xsl:param name="hidden"/>

		<xsl:for-each select='*'>

			<xsl:call-template name="spreadsheet_row">

				<xsl:with-param name="hidden" select="$hidden"/>

				<xsl:with-param name="hasChild" select="info"/>

				<xsl:with-param name="expanded" select='info'/>

			</xsl:call-template>

		</xsl:for-each>

	</xsl:template>

	

	<xsl:template name="spreadsheet_values_def">

		<xsl:param name="hasChild"/>

		<xsl:param name="expanded"/>

		<xsl:if test="self::*[name() = 'group']"><xsl:attribute name='style'>font-weight:bold</xsl:attribute></xsl:if>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select="string(@name)"/>

			<xsl:with-param name="handleIndent">yes</xsl:with-param>

			<xsl:with-param name="parentList" select='ancestor::*[parent::*]'/>

			<xsl:with-param name="hasChild" select="$hasChild"/>

			<xsl:with-param name="expanded" select="$expanded"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select="string(@value)"/>

		</xsl:call-template>

	</xsl:template>



</xsl:stylesheet>

